﻿var _MODULE_UNDEF = 0;
var _MODULE_PRED = 1;
var _MODULE_NONPRED = 2;
var _MODULE_PREVIEW = 3;
var _MODULE_EXPERT = 4;
var _MODULE_REMOTE = 5;
var _MODULE_IVR = 6;
var _MODULE_BLEND = 7;
var _MODULE_MONITORING = 8;
var _MODULE_HYBRID = 14;
var _MODULE_MANUALDIALING = 15;
var mainlayout = "MainLayout.aspx";


// IntWeb Buttons
var QuitProjBtnId = 'IACTION-3';
var NewCallBtnId = 'IACTION-4';
var CallBackBtnId = 'IACTION-5';
var FindOKBtnId = 'IACTION-8';
var ReviewBtnId = 'IACTION-13';
var ReviewOpenBtnId = 'IACTION-14';
var NextNav = 'NAV_GOFWD';


var iCommon = {

    callServerMethod: function (_pageUrl, _methodName, _data, _onSuccess, _onError, _additionalSettings) {
        var _args = null;
        if (_data !== undefined && _data !== null) {
            _args = _data;
        }

        var errorCallBack = _onError;
        if (_onError == undefined || _onError == null) {
            errorCallBack = function (xhr, msg, e) {
                iCommon.onAjaxPageMethodError(xhr, msg, e);
            }
        }

        var _settings = _additionalSettings || {};
        _settings.type = _settings.type || "POST";
        if (_methodName != null) {
            _settings.url = _pageUrl + "/" + _methodName;
        }
        else {
            _settings.url = _pageUrl;
        }
        _settings.data = _settings.data || _args != null ? JSON.stringify(_args) : null;
        _settings.contentType = _settings.contentType || "application/json; charset=utf-8";
        _settings.dataType = _settings.dataType || "json";
        _settings.success = _onSuccess || iCommon.onAjaxPageMethodSuccess;
        _settings.error = errorCallBack || iCommon.onAjaxPageMethodError;

        $.ajax(_settings);
    },

    onAjaxPageMethodError: function (xhr, msg, e) {

        if (xhr.status < 500 && xhr.status !== 401) {
            if (xhr.responseText != undefined && xhr.responseText != null) {
                alert(xhr.responseText);
            }
            else if (msg != undefined && msg != null) {
                _messageToDisplay = msg;
                if (e != undefined && e != null) {
                    _messageToDisplay += ": " + e;
                }
            }
        }

        if (xhr != null) {
            if (xhr.status < 500 && xhr.status !== 401) {
                error("onAjaxPageMethodError: " + xhr.responseText);
                try {
                    throw (xhr.responseText);
                }
                catch (e) { }
            }
        }
        else {
            //throw ('onAjaxPageMethodError: ' + msg);
        }
    },
    onAjaxPageMethodSuccess: function (_result) {
    }
};


var SessionTimeout = {

    //
    //  m_SessionTimeout       -> valeur en seconde de l'expiration de voxco.agent
    //  m_SessionTimerId        -> Un id de timer ( settimeout )
    //  m_onCloseDialog         -> A la fermeture du dialog modal , m_onCloseDialog est apppele par le dialog. La responsabilite du callback
    //                             est de fermer la session de voxco.agent si necessaire
    //  m_DialogTimeout         -> Le expiration du dialogue.  Voir le fichier app.conf
    //  m_SessionTimeoutEnable  -> Est ce que le timeout de session est actif. Voir le fichier app.conf
    //
    m_SessionTimeout: 0,
    m_DefaultTimeout: 20*60*1000 ,
 
    m_onCloseDialog: null,
    m_SessionTimerId: 0,
    m_StoreSessionTimeout: 0,
    m_DialogTimeout: 10,
    m_bSessionTimeoutEnable: false,
    init: function (onCloseDialog, bEnable, dialogtimeout) {

        if (typeof bEnable == "boolean")
            this.m_bSessionTimeoutEnable = bEnable;

        this.m_DialogTimeout = dialogtimeout;
        this.m_onCloseDialog = onCloseDialog;
    },


    _warning: function (message) {

        if (typeof ConsoleDebug != "object")
            return;

        ConsoleDebug._warning(message);
        return;
    },

   
    _debug: function (message) {

        if (typeof ConsoleDebug != "object")
            return;

        ConsoleDebug._debug(message);
        return;
    },

    _info: function (message) {

        if (typeof ConsoleDebug != "object")
            return;

        ConsoleDebug._info(message);
        return;
    },

    getSessionTimeout: function () {
        var sessionTimeout = this.m_DefaultTimeout;
        if (this.m_SessionTimeout > 0)
            sessionTimeout = this.m_SessionTimeout;

        this._debug("getSessionTimeout> the session timeout is: " + sessionTimeout);
        return sessionTimeout;
    },

    isSessionTimeoutStarted: function () {

        var bStarted = false;

        //
        // on considere le timer de session partie si et seulement si le timer de session est actif ( fichier app.config) et que nous
        // un timer de demarrer
        //
        if (this.isEnable() == true &&  this.m_SessionTimerId != 0 )
            bStarted = true ;

        return bStarted;
    },

    StartInboundSessionTimeout: function (timeout) {

        if (this.isEnable() == false)
            return;


        //
        //  Lorsque l'appel inbound est recu , le timeout appartient au websapce de la file ACD. Si 
        //  les valeurs sont entre le webspac du module associe a module blend et la file ACD , nous devons sauvegarder la valeur predente
        //  et la remettre en place a la fin de l'appel
        //

        timeout = this.StoreSessionTimeout(timeout);
        this.Restart(timeout);
        return;
    },

    //
    //  Utiliser surtout pour les appels en inbound parce que il est possible que module cati ne soit pas le meme que pour les appels
    //  sortant.
    //  Donc nous sauvegardons la valeur pour la ramener a la fin de l'appel. Voir interviewComplete
    //

    StoreSessionTimeout: function ( timeout ) {

        if (timeout > 0) {
            this.m_StoreSessionTimeout = this.getSessionTimeout();
            this.m_SessionTimeout = timeout;
        }
        else
            timeout = this.getSessionTimeout();

        this._info("StoreSessionTimeout> storing session timeout for inbound call... The session timeout  will restore at the end of the innbound call -- " + this.m_StoreSessionTimeout + " ms" ); 
        return timeout;
    },

    RestoreSessionTimeout: function () {

        if (this.m_StoreSessionTimeout > 0) {
            this._info("RestoreSessionTimeout> restoring session timeout " + this.m_StoreSessionTimeout + " ms"); 
            this.m_SessionTimeout = this.m_StoreSessionTimeout;
            this.m_StoreSessionTimeout = 0;
        }
    },


    //
    // Touch
    //
    // Cette methode est appelee:
    //
    // 1) a chaque click de la bar vertical -- onClick() de closesentinel.aspx
    // 2) On chargement de chaque pages du questionnaire -- onMainLoad() de closesentinel.aspx
    //
    Touch: function () {

        if (this.isEnable() == false)
            return;

        this.Restart();
        this.CloseDialog();
    },

    isEnable: function () {
        return this.m_bSessionTimeoutEnable;
    },
    //
    //  onTimer:
    //
    //  A l'expiration du timeout nous verifions le temps ecoule
    //
    onTimer: function () {
       
        if (typeof SessionTimeout.m_onCloseDialog == "function") {
            SessionTimeout._info("onTimer> The agent session is expired. Asking for resume session");
            SessionTimeout.onSessionTimeout();
            return;
        }

       
        return;
    },

    Restart: function (timeout) {

        if (this.isEnable() == false)
            return;

        this.StopTimer();
        if (typeof timeout != "number") {
            timeout = this.m_SessionTimeout;
        }

        this._info("Restart> Restarting timer with remaining time of " + timeout + "ms");
        this.m_SessionTimerId = setTimeout(this.onTimer, timeout);
        return;
    },


    StopTimer: function () {

        if (this.m_SessionTimerId != 0)
            clearTimeout(this.m_SessionTimerId);

        m_SessionTimerId = 0;
    },

    Start: function (timeout) {

     
        if (this.isEnable() == false)
            return;

        this.CloseDialog();
        //
        // timeout < 0 nous avons un probleme nous mettons une valeur par defaut
        //

        this.m_SessionTimeout = timeout;
        if (timeout == 0 || typeof timeout != "number")
            this.m_SessionTimeout = this.m_DefaultTimeout;
      
        this.StopTimer();
        this.m_SessionTimerId = setTimeout(this.onTimer, this.m_SessionTimeout);
    },


    CloseDialog: function () {

        if (this.isEnable() == false)
            return;

        DialogBox.CloseDialog();
    },

    onSessionTimeout: function () {

        var toolbar = gClassManager.getToolbar();
        var message = toolbar.getVAResourceValue('STR_SessionTimeout');
        var resume = toolbar.getVAResourceValue('STR_Resume');

        var properties = { context: gClassManager.getDialogBoxDocument(), timeout: this.m_DialogTimeout, onClose: this.m_onCloseDialog, accept: resume };
        DialogBox.showDialog(properties, message);
    }
}


var UrlHelper = {

    m_szLastUrl: "",

    unsetLastUrl: function () {
        this.m_szLastUrl = "";
    },

    isUrlChanged: function (_url) {

        if (typeof _url != "string" || _url.length == 0)
            return false;

        var bLastUrl = false;
        var url = _url.toLowerCase();
        if (this.m_szLastUrl.length > 0 && this.m_szLastUrl == url)
            bLastUrl = true;

        this.m_szLastUrl = url;
        return bLastUrl;
    }
};


function error(szMessage) {
    if (typeof Logger != "object")
        return;

    Logger._error(szMessage);
    return;
}


function warning(szMessage) {
    if (typeof Logger != "object" || Logger == null)
        return;

    Logger._warning(szMessage);
    return;
}

function info(szMessage) {
    if (typeof Logger != "object" || Logger == null)
        return;

    Logger._info(szMessage);
    return;
}

function debug(szMessage) {
    if (typeof Logger != "object" || Logger == null)
        return;

    Logger._debug(szMessage);
    return;
}


function trace(szMessage) {
    if (typeof Logger != "object" || Logger == null )
        return;

    Logger._trace(szMessage);
    return;
}



function setModuleName( moduleName ) {

    var Assignment = gClassManager.getAgentAssignmentClass();
    var _name = Assignment.getModuleName();
    if (typeof moduleName == "string")
        _name = moduleName;

    info("setModuleName> setting module project from project setting -- name " + _name);

    try {
        var topHeader = gClassManager.getHeaderFrame();
        _txtobj = topHeader.document.getElementById('prontoModuleNameTxt');
        if (_txtobj != undefined) {
            _txtobj.innerHTML = _name;
            _txtobj.title = _name;
        }
    }
    catch (e) {
        error("setProntoProjectName> not able to set project module name -- raison: " + e.message);
    }
}

function Url(httpLink) {
    var m_httpLink = httpLink;

    this.Get = function () {
        var host = $.url(m_httpLink).attr('host');
        var protocol = $.url(m_httpLink).attr('protocol');

        return protocol + "://" + host;
    };

    this.isUrlExtension = function (szExtension) {

        
    };
}



function ConfigManager() {

    var that = this;
    var additionnalSetting = {};
    additionnalSetting.async = false;
   
  
    var AdvanceSetting = {};

    var bProntoSettingSet = false;
    var bAdvanceSettingSet = false;
    var ProntoSetting = {};


    var onLog = null;
    var agentRemoteCallInfo = {};
    var ProntoCallResult = {};

    var m_CssClassName = [];
    var m_baseUrl = [];
    var m_threadId = [];


    this.ClearProjectSetting = function () {
        bProjectSettingSet = false;
    };

    this.ClearProntoSetting = function () {
        bProntoSettingSet = false;
    };

    this.SetProntoSetting = function (_result) {

        mainlayout = _result.d.m_szFrameLayoutDocument;
        ProntoSetting.m_szFrameLayoutDocument = _result.d.m_szFrameLayoutDocument;
        ProntoSetting.m_bAllowAutoPreviewCall = _result.d.m_bAllowAutoPreviewCall;
        ProntoSetting.m_bLogEnable = _result.d.m_bLogEnable;
        ProntoSetting.m_bAdvanceLogTrace = _result.d.m_bAdvanceLogTrace;
        ProntoSetting.m_bAlert = _result.d.m_bAlert;
        ProntoSetting.m_bVisualCue = _result.d.m_bVisualCue;
        ProntoSetting.m_iAgentDialPadTimeout = _result.d.m_iAgentDialPadTimeout;
        ProntoSetting.m_szBackgroundColor = _result.d.m_szBackgroundColor;
        ProntoSetting.m_bCustomAlert = _result.d.m_bCustomAlert;
        ProntoSetting.m_bEnableCloseOnManualDialPad = _result.d.m_bManualDialPadCloseButton;
        ProntoSetting.m_bConsoleDebugEnable = _result.d.m_bConsoleDebugEnable;
        ProntoSetting.m_szBlendUrl = _result.d.m_szBlendUrl;
        ProntoSetting.m_iUserId = _result.d.m_iUserId;
        ProntoSetting.m_bPreventBack = _result.d.m_bPreventBack;
        ProntoSetting.m_iAssigmentDialogTimeout = _result.d.m_iAssigmentDialogTimeout;
        ProntoSetting.m_NoMoreSampleMsg = '';
        ProntoSetting.m_iSessionTimeoutDialogTimeout = _result.d.m_iSessionTimeoutDialogTimeout;
        ProntoSetting.m_bSessionTimeoutEnable = _result.d.m_bSessionTimeoutEnable;
        if (_result.d.m_szNoMoreSampleMsg.length != 0) {
            ProntoSetting.m_NoMoreSampleMsg = _result.d.m_szNoMoreSampleMsg;
        }

        return;
    };

    this.GetAdvanceSettingClass = function () {
        if (AdvanceSetting == undefined) {
            return null;
        }

        return AdvanceSetting;
    }

    this.SetAdvanceSetting = function (_result) {
        AdvanceSetting.m_bAdvanceModeEnable = _result.d.m_bAdvanceModeEnable;
        AdvanceSetting.m_bUserDialingEnable = _result.d.m_bUserDialingEnable;
        AdvanceSetting.m_bConferenceEnable = _result.d.m_bConferenceEnable;
        AdvanceSetting.m_bTransferEnable = _result.d.m_bTransferEnable;
        AdvanceSetting.m_selectOptions = _result.d.m_selectOptions;

    }

 

    this.isAdvanceModeEnable = function () {

        if (typeof AdvanceSetting != "object" || typeof AdvanceSetting.m_bAdvanceModeEnable != "boolean")
            return false;

        return AdvanceSetting.m_bAdvanceModeEnable;
    }

    this.GetFrameLayoutDocument = function () {

        var szFrameLayoutDoucment = "FrameLayout.aspx";
        if (typeof ProntoSetting.m_szFrameLayoutDocument == "string")
            szFrameLayoutDoucment = ProntoSetting.m_szFrameLayoutDocument;

        return szFrameLayoutDoucment; 
    }



    this.isSessionTimeoutEnable = function () {

        var bEnable;
        if (typeof ProntoSetting.m_bSessionTimeoutEnable == "boolean")
            bEnable = ProntoSetting.m_bSessionTimeoutEnable;

        return bEnable
       
    }

    this.getSessionTimeoutDialogTimeout = function () {
        var timeout = 10;
        if (ProntoSetting.m_iSessionTimeoutDialogTimeout != undefined)
            timeout = ProntoSetting.m_iSessionTimeoutDialogTimeout;

        return timeout;
    }


    this.getAssignmentDialogTimeout= function()
    {
        var timeout = 10;
        if (ProntoSetting.m_iAssigmentDialogTimeout != undefined)
            timeout = ProntoSetting.m_iAssigmentDialogTimeout;

        return timeout;
    }

    this.isCrossDomain = function (catiUrl) {
        var bCrossDomain = true;

        var voxcoAgentUrl = $.url();
        var _cati = $.url(catiUrl);

        var _voxcoAgentHost = $.url().attr('host');
        var _CatiHost = _cati.attr('host');

        _voxcoAgentHost = _voxcoAgentHost.toLowerCase();
        _CatiHost = _CatiHost.toLowerCase();


        if ((voxcoAgentUrl.attr('protocol') === _cati.attr('protocol')) &&
            (_voxcoAgentHost === _CatiHost)) {
            bCrossDomain = false;
        }

        return bCrossDomain;
    }

    this.SetEnableCloseOnManualDialPad = function (_result) {
        m_bEnableCloseOnManualDialPad = _result.d;
    };

    this.isBlendUrl = function ( url ){
      
        if (ProntoSetting.m_szBlendUrl == undefined || ProntoSetting.m_szBlendUrl.length == 0 ) {
            return false
        }

        if (url.indexOf(ProntoSetting.m_szBlendUrl) < 0) {
            return false;
        }

        return true;
    }

    this.GetNoSampleMessage = function () {

        if (ProntoSetting.m_NoMoreSampleMsg == undefined) {
            ProntoSetting.m_NoMoreSampleMsg = "";
        }

        return ProntoSetting.m_NoMoreSampleMsg;
    }

    this.setUserId = function (userId) {
        if (typeof userId == "string"){
            ProntoSetting.m_iUserId = userId;
        }
    }

    this.getUserId = function () {

        // pour des simplicite de code , le userid peut etre obtenu du pronto setting ou de l'object ProntoSettings
        // Les deux sont equivalents mais pas initialiser au meme moment.
        //
        // ProntoSetting -> au chargement de frame closesentinel
        // ProjectSetting -> apres la selection de Projet.
        //
        // Comme le user id est une information vitale , nous ne prenons aucune chance.
        //

        var userid = 0;
        if (ProntoSetting.m_iUserId != undefined) {
            userid = ProntoSetting.m_iUserId;
        }
      
        return userid;
    };

    this.getWorkstationId = function () {

        var workstationid = 0;
        if (ProntoSetting.m_iWorkStationId != undefined)
            workstationid = ProntoSetting.m_iWorkStationId;

        return workstationid;
    }


    this.getPreventBack = function () {

        var enable = false;
        if (typeof ProntoSetting.m_bPreventBack == "boolean")
            enable = ProntoSetting.m_bPreventBack;

        return enable;
    }
    
    this.getConsoleDebugEnable = function () {

        var enable = false;
        if (typeof ProntoSetting.m_bConsoleDebugEnable == "boolean")
            enable = ProntoSetting.m_bConsoleDebugEnable;

        return enable;
    }
   
    this.getBackgroundColor = function () {

        var color = "";
        if (ProntoSetting.m_szBackgroundColor != undefined)
            color = ProntoSetting.m_szBackgroundColor;

        return color;
    }


    this.getOnDialPadTimeout = function () {

        var timeout = 0;
        if (ProntoSetting.m_iAgentDialPadTimeout != undefined)
            timeout = ProntoSetting.m_iAgentDialPadTimeout;

        return timeout;
    }


    this.getDisplayAlert = function () {

        var bAlert = true;
        if (ProntoSetting.m_bAlert != undefined) {
            bAlert = ProntoSetting.m_bAlert;
        }

        return bAlert;
    };

    this.SetCallResult = function (_result) {

        ProntoCallResult.m_ProntoCallResult = _result.d.m_ProntoCallResult;
        ProntoCallResult.m_ProntoCallResultText = _result.d.m_ProntoCallResultText;
    };

    this.ClearThreadId = function () {
        m_threadId = {};
    };

    


    this.SetThreadId = function (_result) {

        var catiModule = AgentAssignment.GetInboundCatiId();
        if (catiModule == 0 ) {
            catiModule = AgentAssignment.getCatiId();
        }

        if (_result == undefined) {
            return null;
        }

        var threadid = _result.getItem('THREADID');
        if (threadid == null && threadid == undefined) {
            return null;
        }

        // on retourne le treadid pour fin de log seulement ... si null nous avons toujours la meme connexion avec intweb...

        if (m_threadId[catiModule] == undefined || m_threadId[catiModule] != threadid) {
            m_threadId[catiModule] = threadid;
            return threadid;
        }

        return null;
    };

    this.ClearThreadId = function (CatiId) {
        if (CatiId != undefined && CatiId > 0)
            m_threadId[CatiId] = '';
    }

 

    this.getThreadId = function (inboundCatiProject, catiId ) {
       
        var catiModule = catiId;
        if (inboundCatiProject != 0 && inboundCatiProject != undefined) {
            catiModule = inboundCatiProject;
        }

        //var threadid = undefined;
        if (m_threadId[catiModule] != undefined) {
            return m_threadId[catiModule];
        }

        return; // threadid;
    };

    this.getAdvanceSetting = function (bForce) {

        if (bAdvanceSettingSet == true && (bForce != undefined && bForce == false)) {
            return false;
        }

        bAdvanceSettingSet = true;
        this.Get("getAdvanceSetting", this.SetAdvanceSetting, {});
        return true;
    };


    this.getEnableCloseOnManualDialPad = function () {

        var bEnable = true;
        if (ProntoSetting.m_bEnableCloseOnManualDialPad != undefined)
            bEnable = ProntoSetting.m_bEnableCloseOnManualDialPad;


        return bEnable;
    };

    
    this.setCssClassName = function (_result) {
        m_CssClassName[_result.d.m_ClassName] = _result.d.m_CssBodyName;
    };

    this.getCssClassName = function (name) {

        if (m_CssClassName[name] == undefined) {
            this.Get("getCssClassName", this.setCssClassName, { ClassName: name });
        }

        return m_CssClassName[name];
    };

    this.getVisualCue = function () {

        var result = false;
        if (ProntoSetting.m_bVisualCue != undefined) {
            result = ProntoSetting.m_bVisualCue;
        }

        return result;
    };


    this.isCallPreviewDelayAllowed = function () {

        var result = false;

        if (ProntoSetting.m_bAllowAutoPreviewCall != undefined) {
            result = ProntoSetting.m_bAllowAutoPreviewCall;
        }

        return result;
    };

    this.getProntoSetting = function (bForce, bAsync) {

        if (bProntoSettingSet == true && (bForce != undefined && bForce == false)) {
            return;
        }

        var additionnalSetting = {};
        if (typeof bAsync == "boolean")
            additionnalSetting.async = bAsync;


        bProntoSettingSet = true;
        this.Get("getProntoSetting", this.SetProntoSetting, additionnalSetting);
        return;
    };

   
 
    this.getBlendUrl = function(){
        return ProntoSetting.m_szBlendUrl;
    }

    this.getAdvanceLogEnable = function () {

        var bLogEnable = false;
        if (ProntoSetting.m_bAdvanceLogTrace != undefined) {
            bLogEnable = ProntoSetting.m_bAdvanceLogTrace;
        }

        return bLogEnable;
    }


    this.getCustomAlert = function () {

        var bCustomAlert = false;
        if (ProntoSetting.m_bCustomAlert != undefined) {
            bCustomAlert = ProntoSetting.m_bCustomAlert;
        }

        return bCustomAlert;
    }

    this.isRemoteOutbound = function()
    {
        var bRemoteOutbound = false;
        if (ProntoSetting.m_bRemoteOutbound != undefined) {
            bRemoteOutbound = ProntoSetting.m_bRemoteOutbound;
        }

        return bRemoteOutbound
    }

    this.getLogEnable = function () {
        var bLogEnable = false;
        if (ProntoSetting.m_bLogEnable != undefined) {
            bLogEnable = ProntoSetting.m_bLogEnable;
        }

        return bLogEnable;
    };
 
    this.setRemoteAgentCallInfo = function (_agentRemoteCallInfo) {
        agentRemoteCallInfo = _agentRemoteCallInfo;
    };

    this.getRemoteAgentUrl = function (urlStart) {

        var url = urlStart + 'ExtensionType=' + agentRemoteCallInfo.exttype;
        url += '&AgentPhoneNumber=' + agentRemoteCallInfo.extphone;
        url += '&TelephonyServerId=' + agentRemoteCallInfo.dialer;
        url += '&station=' + agentRemoteCallInfo.stationno;

        return url;
    };

    this.GetCallResult = function (_code) {

        this.Get("GetProntoCallResult", this.SetCallResult, { callResult: _code });
        return ProntoCallResult;
    };

    this.Get = function (_method, _Success, _data) {
        iCommon.callServerMethod("CloseSentinel.aspx", _method, _data, _Success, null, additionnalSetting);
        return;
    };
}


function ClassManager() {


    var m_Manager = this;
    var m_MainFrame = top.window;

    this.getConfigManager = function () {
        var CloseSentinelFrame = m_Manager.getCloseSentinelFrame();
        return CloseSentinelFrame.gConfigManager;
    };

    this.getCloseSentinelFrame = function () {
        return m_Manager.getMainFrame().getFrameContent("f0");
    };

    this.getToolbar = function () {
        return m_Manager.getMainFrame().getFrameContent("f1");
    };

    this.getSharedFrame = function () {
        return m_Manager.getMainFrame().getFrameContent("f2");
    }

    this.getHeaderFrame = function(){
        return m_Manager.getMainFrame().getFrameContent("ft");
    }

    this.getDialogFrameContent = function () {
        return m_Manager.getSharedFrame();
    }

    this.getDialogBoxDocument = function () {
        return m_Manager.getMainFrame().getDialogBoxDocument();
    }

    this.getFrameSet= function()
    {
        return m_Manager.getMainFrame().getFrameSet();
    }

    this.getMainFrame = function()
    {
        if (typeof m_Manager.m_MainFrame != "object")
            m_Manager.m_MainFrame = top.window;

        return m_Manager.m_MainFrame;
    }

    this.getFooterFrame = function () {
        return m_Manager.getMainFrame().getFrameContent("ff");
    }

    this.getVisibleFrameset = function () {
        return m_Manager.getMainFrame().getFrame('fm0');
    }

    this.getManualDialing = function () {
        return m_Manager.getCloseSentinelFrame().gManualDialing;
    }


    this.getDialogObject = function () {
        return m_Manager.getCloseSentinelFrame().DialogBox;
    }



    this.getNewLogger = function () {
        return m_Manager.getCloseSentinelFrame().Logger;
    }

    this.getEventPublisher = function () {
        return m_Manager.getCloseSentinelFrame().gEventPublisher;
    }

    this.getCrossDomainClass = function () {
        return m_Manager.getCloseSentinelFrame().CrossDomainInfo;
    }

    this.getAgentAssignmentClass = function () {
        return m_Manager.getCloseSentinelFrame().AgentAssignment;
    }

    this.getCustomDialPad = function () {

        if (m_Manager.getCloseSentinelFrame().gCustomDialPad == undefined)
            return m_Manager.getCloseSentinelFrame().gManualDialing;

        return m_Manager.getCloseSentinelFrame().gCustomDialPad;
    }

    this.getCallClass = function () {
        return m_Manager.getCloseSentinelFrame().CallClass;
    }

    this.getButtonClass = function()
    {
        return m_Manager.getToolbar().gButtonClass;
    }

    this.getPingFrame = function () {
        return m_Manager.getMainFrame().getFrameContent("fPing");
    };

    this.getSessionTimeoutClass = function () {
        var CloseSentinelFrame = m_Manager.getCloseSentinelFrame();
        return CloseSentinelFrame.SessionTimeout;
    };

    this.getPingClass = function () {
        var CloseSentinelFrame = m_Manager.getCloseSentinelFrame();
        return CloseSentinelFrame.PingIntWeb;
    };

    this.getTBWebControl = function () {
        return m_Manager.getToolbar().tbWebControl;
    };

    
    this.createNoSampleInstance = function () {
        m_Manager.getCloseSentinelFrame().gNoSampleAvailable = new NoSampleAvailable;
        m_Manager.getCloseSentinelFrame().gNoSampleAvailable.SetDefault();
    }

    this.getNoSampleClass = function () {
        return m_Manager.getCloseSentinelFrame().gNoSampleAvailable;
    };
}


var gClassManager = null;
function createClassManager()
{
    if (gClassManager == null)
        gClassManager = new ClassManager();

    return gClassManager;
}

function getClassManager()
{
    return createClassManager();
}

var gConfigManager = new ConfigManager;

